/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class HiloChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 2;
    PlotPoint[][][] pts;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        this.cachePlotData = this.dataObject.getBufferPlotData();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.holeValue = this.dataObject.holeValue;
        this.inverted = this.xaxis.isVertical;
        int n2 = this.seriesList.length / 2;
        if (!this.cachePlotData && n == -1) {
            if (this.pts == null) {
                this.pts = new PlotPoint[n2][][];
            }
            return;
        }
        if (n == -1 || n == 0) {
            this.xlim = new MinMax();
            this.ylim = new MinMax();
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
        this.pts = new PlotPoint[n2][][];
        int n3 = n == -1 ? 0 : n;
        int n4 = n == -1 ? n2 : n + 1;
        int n5 = n3;
        while (n5 < n4) {
            this.pts[n5] = null;
            boolean bl = true;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            int n9 = 2 * n5;
            int n10 = 0;
            while (n10 < 2) {
                ChartDataViewSeries chartDataViewSeries = this.seriesList[n9];
                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                    bl = false;
                    break;
                }
                n6 = Math.min(n6, chartDataViewSeries.maxXIndex());
                n6 = Math.min(n6, chartDataViewSeries.maxYIndex());
                n7 = Math.min(n7, chartDataViewSeries.getFirstPoint());
                n8 = Math.min(n8, chartDataViewSeries.getLastPoint());
                ++n10;
                ++n9;
            }
            if (bl) {
                this.pts[n5] = new PlotPoint[n6][];
                int n11 = n7;
                while (n11 <= n8) {
                    int n12 = 0;
                    this.pts[n5][n11] = new PlotPoint[2];
                    int n13 = 2 * n5;
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n13++];
                    double d = chartDataViewSeries.getX(n11);
                    double d2 = chartDataViewSeries.getY(n11);
                    chartDataViewSeries = this.seriesList[n13++];
                    double d3 = chartDataViewSeries.getX(n11);
                    double d4 = chartDataViewSeries.getY(n11);
                    this.financialClip(d, d2, d3, d4, this.xlim, this.ylim, this.pts[n5][n11], n11, n12, this.inverted, false);
                    ++n11;
                }
            }
            ++n5;
        }
    }

    public void draw(Graphics graphics) {
        if (this.pts == null) {
            return;
        }
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        boolean bl = false;
        PlotPoint plotPoint = null;
        try {
            if (this.seriesList == null) {
                return;
            }
            int n = 0;
            while (n < this.pts.length) {
                if (!this.cachePlotData) {
                    this.recalc(n);
                }
                if (this.pts[n] != null) {
                    JCChartStyle jCChartStyle;
                    boolean bl2 = true;
                    int n2 = 2 * n;
                    int n3 = 0;
                    while (n3 < 2) {
                        if (!this.seriesList[n2].isShowing) {
                            bl2 = false;
                            break;
                        }
                        ++n3;
                        ++n2;
                    }
                    if (bl2 && (jCChartStyle = this.seriesList[2 * n].getStyle()) != null) {
                        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                        int n4 = 0;
                        while (n4 < this.pts[n].length) {
                            if (this.pts[n][n4] != null) {
                                bl = false;
                                int n5 = 0;
                                while (n5 < this.pts[n][n4].length) {
                                    plotPoint = this.pts[n][n4][n5];
                                    if (plotPoint == null || plotPoint.px == Integer.MAX_VALUE || plotPoint.py == Integer.MAX_VALUE) {
                                        bl = false;
                                    } else {
                                        point.x = this.pts[n][n4][n5].px;
                                        point.y = this.pts[n][n4][n5].py;
                                        if (bl) {
                                            jCLineStyle.draw(graphics, point2.x, point2.y, point.x, point.y);
                                        }
                                        point2.x = point.x;
                                        point2.y = point.y;
                                        bl = true;
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                        if (!this.cachePlotData) {
                            this.pts[n] = null;
                        }
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        PlotPoint plotPoint = null;
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (!this.cachePlotData) {
                this.recalc(n5);
            }
            if (this.pts[n5] != null) {
                boolean bl = true;
                int n6 = 2 * n5;
                int n7 = 0;
                while (n7 < 2) {
                    if (!this.seriesList[n6].isShowing) {
                        bl = false;
                        break;
                    }
                    ++n7;
                    ++n6;
                }
                if (bl) {
                    int n8 = 0;
                    while (n8 < this.pts[n5].length) {
                        if (this.pts[n5][n8] != null) {
                            int n9 = 0;
                            while (n9 < this.pts[n5][n8].length) {
                                plotPoint = this.pts[n5][n8][n9];
                                if (plotPoint != null && plotPoint.px != Integer.MAX_VALUE && plotPoint.py != Integer.MAX_VALUE && plotPoint.drawPoint) {
                                    int n10 = Integer.MAX_VALUE;
                                    switch (n) {
                                        case 1: {
                                            n10 = Math.abs(plotPoint.px - point2.x);
                                            break;
                                        }
                                        case 2: {
                                            n10 = Math.abs(plotPoint.py - point2.y);
                                            break;
                                        }
                                        default: {
                                            n10 = JCChartUtil.distance(point2.x, point2.y, plotPoint.px, plotPoint.py);
                                        }
                                    }
                                    if (n10 < n4) {
                                        n2 = n5 * 2 + n9;
                                        n3 = plotPoint.point;
                                        n4 = n10;
                                    }
                                }
                                ++n9;
                            }
                        }
                        ++n8;
                    }
                    if (!this.cachePlotData) {
                        this.pts[n5] = null;
                    }
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.drawingOrder / 2;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n2 = jCDataIndex.point;
        PlotPoint[] plotPointArray = this.pts[n][n2];
        int n3 = jCDataIndex.seriesIndex - n * 2;
        if (n3 >= 0 && n3 < 2 && plotPointArray[n3] != null && plotPointArray[n3].px != Integer.MAX_VALUE && plotPointArray[n3].py != Integer.MAX_VALUE) {
            this.start = new Point(plotPointArray[n3].px + this.r.x, plotPointArray[n3].py + this.r.y);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 2;
    }
}

